<?php
/**
 * The Header for our theme.
 *
 * Displays all of the <head> section and everything up till <main id="main">
 *
 * @package Blox Monochrome
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta http-equiv="x-ua-compatible" content="ie=edge" />
<meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=1" />
<title><?php wp_title( '|', true, 'right' ); ?></title>
<link rel="profile" href="http://gmpg.org/xfn/11">
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
<link href='http://fonts.googleapis.com/css?family=Raleway:900,100,300,400,700' rel='stylesheet' type='text/css'>

<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<div id="page" class="hfeed site grid-container">
	<?php do_action( 'before' ); ?>
	<header id="masthead" class="site-header grid-100" role="banner">
		<div class="site-branding">
			<h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
			<h2 class="site-description thin"><?php bloginfo( 'description' ); ?></h2>
		</div>
	</header><!-- #masthead -->
	<nav role="navigation" class="grid-100">
		<!-- <h1 class="menu-toggle"><?php _e( 'Menu', 'blox' ); ?></h1> -->
		<!-- <div class="screen-reader-text skip-link"><a href="#content" title="<?php esc_attr_e( 'Skip to content', 'blox' ); ?>"><?php _e( 'Skip to content', 'blox' ); ?></a></div> -->

		<?php wp_nav_menu( array( 'theme_location' => 'primary', 'container' => '', 'depth' => 3 ) ); ?>
	</nav><!-- #site-navigation -->
	<div id="content" class="site-content grid-100">
		
